/*
 * Decompiled with CFR 0.152.
 */
package com.smart.utils;

import android.util.Log;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SerialPortControl {
    private static final String TAG = "SerialPortControl";
    private FileDescriptor mFd;
    private FileInputStream mFileInputStream;
    private FileOutputStream mFileOutputStream;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SerialPortControl(File device, int baudrate, int flags) throws SecurityException, IOException {
        if (device == null) {
            return;
        }
        if (!device.canRead() || !device.canWrite()) {
            try {
                Process su = Runtime.getRuntime().exec("su");
                String cmd = "chmod 666 " + device.getAbsolutePath() + "\nexit\n";
                su.getOutputStream().write(cmd.getBytes());
                if (su.waitFor() == 0 && device.canRead() && device.canWrite()) {
                    // empty if block
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"SerialPortControl.class use shell command error", (Throwable)e);
            }
        }
        this.mFd = this.open(device.getAbsolutePath(), baudrate, flags);
        if (this.mFd == null) {
            Log.e((String)TAG, (String)"native open returns null");
            throw new IOException();
        }
        this.mFileInputStream = new FileInputStream(this.mFd);
        this.mFileOutputStream = new FileOutputStream(this.mFd);
    }

    public InputStream getInputStream() {
        return this.mFileInputStream;
    }

    public OutputStream getOutputStream() {
        return this.mFileOutputStream;
    }

    private native FileDescriptor open(String var1, int var2, int var3);

    public native void close();

    static {
        System.loadLibrary("serial_port");
    }
}

